using System;
using Server;

namespace Server.Items
{
	public class DemonSkull : BoneHelm
	{
		public override int ArtifactRarity{ get{ return 11; } }

		public override int InitMinHits{ get{ return 255; } }
		public override int InitMaxHits{ get{ return 255; } }

		[Constructable]
		public DemonSkull()
		{
			Name = "Demon Skull";
			Hue = 1161;
			Attributes.SpellDamage = 10;
			ArmorAttributes.MageArmor = 1;
			Attributes.RegenHits = 2;
			Attributes.RegenStam = 3;
			PoisonBonus = 5;
			FireBonus = 8;
		}

		public DemonSkull( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}